<?php

/**
 * @Package: WordPress Plugin
 * @Subpackage: Ultra Portfolio
 * @Since: Ultra Portfolio 1.0
 * @Current Version: Ultra Portfolio 3.1
 * @WordPress Version: 3.5 or above
 * This file is part of Ultra Portofolio WordPress Plugin.
 */
add_shortcode('ultra-portfolio', 'uport_shortcode');

function uport_shortcode($atts) {
    $ret = "";
    extract(shortcode_atts(array(
        'id' => '',
        'type' => '',
        'effect' => '',
        'subeffect' => ''
                    ), $atts));
    if ($id != "") {
        return uport_shortcode_display($id,"","","",$type,$effect,$subeffect);
    }
}

function uport_shortcode_display($id, $requesttype = "", $displaymode = "", $uportviewmode = "", $sctype = "", $sceffect = "", $scsubeffect = "") {

    $woo_status = false;
    $uport_full_sc = "";
    ob_start();
    include("uport-def-values.php");

    if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
        $woo_status = true;
    }


    /* --------------------------------------
      Fetch Portfolio Values
      -------------------------------------- */

    //echo "<pre>";
    $catids = uport_catstrs('arr'); //print_r($catids);
    $woocatids = uport_woocatstrs('arr'); //print_r($woocatids);
    $val1arr = uport_get_arr($id, '1'); //print_r($val1arr);
    $val2arr = uport_get_arr($id, '2'); //print_r($val2arr);
    $val3arr = uport_get_arr($id, '3'); //print_r($val3arr);
    $val4arr = uport_get_arr($id, '4'); //print_r($val4arr);

    $autopxs = uport_nonautopxs();
    foreach ($def2arr as $k => $v) {
        if (!isset($val2arr[$k]) || $val2arr[$k] == "") {
            $val2arr[$k] = $def2arr[$k];
        }
    } //print_r($val2arr);
    foreach ($def3arr as $k => $v) {
        if (!isset($val3arr[$k]) || $val3arr[$k] == "") {
            $val3arr[$k] = $def3arr[$k];
        }
    } //print_r($val3arr);
    foreach ($def4arr as $k => $v) {
        if (!isset($val4arr[$k]) || $val4arr[$k] == "") {
            $val4arr[$k] = $def4arr[$k];
        }
    } //print_r($val4arr);

    foreach ($val3arr as $k => $v) {
        if (!in_array($k, $autopxs) && is_numeric($v)) {
            $val3arr[$k] = trim($v) . "px";
        }
    } //print_r($val3arr);


    if($uportviewmode == "showtitle"){
        echo "<h3 style='background:#f5f5f5;font-weight:300;font-size:14px;margin: -21px -21px 21px -21px;padding: 21px;'>".$val1arr['name']."</h3>";
    }



    /* --------------------------------------
      Unique Portfolio ID generator
      -------------------------------------- */

    //$unique = $val1arr['portid'];
    $alpha1 = substr(str_shuffle("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 5);
    $alpha2 = substr(str_shuffle("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 5);
    $pid = "";
    $rand = rand();
    $pid = trim($alpha1 . $id . $rand . $alpha2);
    //echo $pid;



    /* --------------------------------------
      Portfolio Layout Type
      -------------------------------------- */

    $uporttype = "grid";
    $loadscript = "mix";
    $scriptclass = " mix ";

    if (isset($val2arr['uporttype']) && trim($val2arr['uporttype']) != "") {

        $uporttype = $val2arr['uporttype'];
        if ($uporttype == "grid") {
            $loadscript = "mix";
            $scriptclass = " mix ";
        }
        if ($uporttype == "masonary") {
            $loadscript = "iso";
            $scriptclass = " uportiso ";
        }
        if ($uporttype == "slider" || $uporttype == "single") {
            $loadscript = "owl";
            $scriptclass = " item ";
        }
    }

    //echo $uporttype."|"; echo $loadscript."|"; echo $scriptclass."<br>";




    /* --------------------------------------
      Portfolio Categories
      -------------------------------------- */

    $catcount = 0;
    $woocatcount = 0;
    $totalcatcount = 0;
    $catarr = array();
    $catarr = explode("|", $val1arr['categories']);
    $catarr = array_unique(array_filter($catarr));
    //print_r($catarr);
    $catcount = sizeof($catarr);

    $woocatarr = array();
    if($woo_status){
        $woocatarr = explode("|", $val1arr['woocategories']);
        $woocatarr = array_unique(array_filter($woocatarr));
    //print_r($woocatarr);
        $woocatcount = sizeof($woocatarr);
    }

    $totalcatcount = $catcount + $woocatcount;

    if ($totalcatcount > 0) {

        /* --------------------------
          Load Categories
          -------------------------- */
        $catfilterstr = "";
        if ($loadscript == "mix" || $loadscript == "iso") {
            foreach ($catarr as $catfil) {
                if (trim($catids[$catfil]) != "") {
                    $catfilterstr .= "<a class='filter-" . $pid . "' data-filter='category_" . $catfil . "_" . $pid . "' >" . $catids[$catfil] . "</a>";
                }
            }

            if($woo_status){
                foreach ($woocatarr as $woocatfil) {
                    if (trim($woocatids[$woocatfil]) != "") {
                        $catfilterstr .= "<a class='filter-" . $pid . "' data-filter='category_" . $woocatfil . "_" . $pid . "' >" . $woocatids[$woocatfil] . "</a>";
                    }
                }
            }
        }

        if ($loadscript == "owl") {


            $owlnavigation = uport_radiovalue($val4arr['owlnavigation'], "false");
            $owlplaystop = uport_radiovalue($val4arr['owlplaystop'], "false");

            $playstyle = $stopstyle = "";
            $owlautoplay = uport_radiovalue($val4arr['owlautoplay'], "true");
            if($owlautoplay == "true"){ $playstyle = "style='display:none;'";} else { $stopstyle = "style='display:none;'";}

                if($owlnavigation == "true"){$catfilterstr .= '<a class="uport-slide-prev-' . $pid . '"><span class="uporticon-left207"></span></a>';}
                if($owlplaystop == "true"){$catfilterstr .= '<a data-pid="'.$pid.'" '.$playstyle.' class="uport-slide-playstop uport-slide-play-' . $pid . '"><span class="uporticon-play106"></span></a>';}
                if($owlplaystop == "true"){$catfilterstr .= '<a data-pid="'.$pid.'" '.$stopstyle.' class="uport-slide-playstop uport-slide-stop-' . $pid . '"><span class="uporticon-pause44"></span></a>';}
                if($owlnavigation == "true"){$catfilterstr .= '<a class="uport-slide-next-' . $pid . '"><span class="uporticon-right218"></span></a>';}
        }




        /* --------------------------
          Query
          -------------------------- */
        $query = "";
        foreach ($catarr as $c) {
            $query .= "item_category LIKE '%|" . $c . "|%' OR ";
        }
        $query = substr($query, 0, -3);
        //echo $query;

        $orderby = '';
        if(isset($val1arr['sortitemsby']) && $val1arr['sortitemsby'] == "desc"){
            $orderby = ' ORDER BY item_date DESC ';
        }
        else if(isset($val1arr['sortitemsby']) && $val1arr['sortitemsby'] == "title"){
            $orderby = ' ORDER BY item_title ';
        }
        else if(isset($val1arr['sortitemsby']) && $val1arr['sortitemsby'] == "titledesc"){
            $orderby = ' ORDER BY item_title DESC';
        }


        global $wpdb;
        if (trim($query) != "" && $catcount > 0) {
            $list = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'uport_items WHERE ' . $query . ' ' .$orderby.' ');
        }


        /* --------------------------
          Load Woocommerce Item
          -------------------------- */
        $wooitem = array();

        if($woo_status){
            if(isset($val1arr['sortitemsby'])){
                $woolist = uport_wooitems($woocatarr,$val1arr['sortitemsby']);
            } else {
                $woolist = uport_wooitems($woocatarr);
            }

            if (sizeof($woolist) > 0) {
                //echo "<pre>"; print_r($woolist); echo "</pre>"; 
                foreach ($woolist as $a) {
                    $aid = "wc" . $a->item_id;
                    $wooitem[$aid] = uport_item_from_obj($a, $pid, $val2arr, $woocatids);
                }
            }
        }

        //echo "<pre>"; print_r($wooitem); echo "</pre>";

        /* --------------------------
          Load Each Item
          -------------------------- */
        $item = array();
        if (sizeof($list) > 0) {
            //echo "<pre>"; print_r($list); echo "</pre>"; 
            foreach ($list as $a) {
                $aid = $a->item_id;
                $item[$aid] = uport_item_from_obj($a, $pid, $val2arr, $catids);
            }
        }

        //echo "<pre>"; print_r($item); echo "</pre>";

        $allitem = array();
        $allitem = array_merge($item, $wooitem);

        // sorting all items based on selected option
        $allitem = sort_shortcode_items_by_order($allitem,$val1arr);
        //echo "<pre>"; print_r($allitem); echo "</pre>"; 


        /* --------------------------
          Pick to Show details
          -------------------------- */
        $showthis = explode("|", $val2arr['showdetails']);
        $showthis = array_unique(array_filter($showthis));

        $showthissub = explode("|", $val2arr['showdetailssub']);
        $showthissub = array_unique(array_filter($showthissub));

        //echo "<pre>"; print_r($showthis); print_r($showthissub); echo "</pre>";

        /* -------------------------------------
          Pick effects and animations
          ------------------------------------- */
        $mixeffects = "";
        $mixeffectsexp = array_unique(array_filter(explode("|", $val4arr['mixeffects'])));
        foreach ($mixeffectsexp as $mixeff) {
            $mixeffects .= "'" . $mixeff . "', ";
        } $mixeffects = substr($mixeffects, 0, -2);

        $mixeasexp = explode("|", $val4arr['mixeasing']);
        $mixeasexp = array_filter($mixeasexp);
        $mixeasing = $mixeasexp[0];

        $mixspeed = trim($val4arr['mixspeed']);

        $isoeffect = trim($val4arr['isoeffects']);

        //print_r($val2arr);print_r($val3arr); //echo "</pre>";

        if ($loadscript == "iso") {
            $scriptclass .= " iso_" . trim($isoeffect) . " ";
        }

        $gtype = "";

        $effexp = explode("|", $val4arr['overlayeffect']);
        $effexp = array_filter($effexp);
        $effcss = $effexp[0];

        $subeffexp = explode("|", $val4arr['overlayeffectsub']);
        $subeffexp = array_filter($subeffexp);
        $subeffcss = $subeffexp[0];


        if(isset($sceffect) && trim($sceffect) != ""){
            $effcss = $sceffect;
        }

        if(isset($scsubeffect) && trim($scsubeffect) != ""){
            $subeffcss = $scsubeffect;
        }

        /* ---------------------------------------------------------
          Select Main Effect type &
          HTML Structure to load
          --------------------------------------------------------- */

        $g1 = array("effect1", "effect2", "effect3", "effect4", "effect5", "effect6", "effect7", "effect8", "effect10", "effect101", "effect102", "effect103");
        $g2 = array("effect11", "effect12", "effect13", "effect14", "effect15", "effect16", "effect17");
        $g3 = array("effect21", "effect22", "effect23", "effect24", "effect25", "effect26", "effect27");
        if (in_array($effcss, $g1)) {
            $gtype = "g1";
            include("uport-g1.php");
        } else if (in_array($effcss, $g2)) {
            $gtype = "g2";
            include("uport-g2.php");
        } else if (in_array($effcss, $g3)) {
            $gtype = "g3";
            include("uport-g3.php");
        }

        echo "<div id='uport_info' data-pid='" . $pid . "' data-effcss='" . $effcss . "' data-gtype='" . $gtype . "'  style='visibility:hidden;height:0px;width:0px;opacity:0;overflow:hidden'></div>";

        //$ret = "hihi";
        //return $ret;
////////
    } // end category count condition
    else {
        echo "<span class='uport_alert_msg'>Please select some category to load portfolio items.</span>";
    }

    $uport_full_sc = ob_get_clean();

    if ($displaymode == "echo") {
        echo $uport_full_sc;
    } else {
        return $uport_full_sc;
    }
}

?>