<?php
if (!class_exists('ET_Builder_Element')) {
    return;
}
class DZutilites
{

    /**
     * Add margin and padding fields
     */
    private static function margin_padding(&$fields, $options, $type)
    {
        $key = $options['key'] . '_' . $type;

        $fields[$key] = array(
            'label'                => sprintf(esc_html__('%1$s %2$s', 'et_builder'), $options['title'], $type),
            'type'                => 'custom_margin',
            'toggle_slug'       => $options['toggle_slug'],
            'sub_toggle'        => $options['sub_toggle'],
            'tab_slug'            => 'advanced',
            'mobile_options'    => true,
            'hover'                => 'tabs',
            'priority'             => $options['priority'],
        );
        $fields[$key . '_tablet'] = array(
            'type'                => 'skip',
            'tab_slug'            => 'advanced',
            'toggle_slug'        => $options['toggle_slug'],
            'sub_toggle'        => $options['sub_toggle']
        );
        $fields[$key . '_phone'] = array(
            'type'                => 'skip',
            'tab_slug'            => 'advanced',
            'toggle_slug'        => $options['toggle_slug'],
            'sub_toggle'        => $options['sub_toggle']
        );
        $fields[$key . '_last_edited'] = array(
            'type'                => 'skip',
            'tab_slug'            => 'advanced',
            'toggle_slug'        => $options['toggle_slug'],
            'sub_toggle'        => $options['sub_toggle']
        );
    }
    static function add_margin_padding($options = array())
    {
        $margin_padding = array();
        $default = array(
            'title'         => '',
            'key'           => '',
            'toggle_slug'   => '',
            'sub_toggle'    => null,
            'option'        => 'both',
            'priority'      => 30
        );
        $args = wp_parse_args($options, $default);

        if ($args['option'] === 'both' || $args['option'] === 'margin') {
            self::margin_padding($margin_padding, $args, 'margin');
        }
        if ($args['option'] === 'both' || $args['option'] === 'padding') {
            self::margin_padding($margin_padding, $args, 'padding');
        }
        return $margin_padding;
    }

    /**
     * Process Margin & Padding styles
     */
    static function set_margin_padding_styles($options = array())
    {
        $default = array(
            'module'            => '',
            'render_slug'       => '',
            'slug'              => '',
            'type'              => '',
            'selector'          => '',
            'hover'             => '',
            'important'         => true
        );
        $options        = wp_parse_args($options, $default);
        extract($options);
        $desktop         = $module->props[$slug];
        $tablet         = $module->props[$slug . '_tablet'];
        $phone             = $module->props[$slug . '_phone'];

        if (class_exists('ET_Builder_Element')) {
            if (isset($desktop) && !empty($desktop)) {
                ET_Builder_Element::set_style($render_slug, array(
                    'selector' => $options['selector'],
                    'declaration' => et_builder_get_element_style_css(
                        $desktop,
                        $options['type'],
                        $options['important']
                    ),
                ));
            }
            if (isset($tablet) && !empty($tablet)) {
                ET_Builder_Element::set_style($render_slug, array(
                    'selector' => $options['selector'],
                    'declaration' => et_builder_get_element_style_css(
                        $tablet,
                        $options['type'],
                        $options['important']
                    ),
                    'media_query' => ET_Builder_Element::get_media_query('max_width_980'),
                ));
            }
            if (isset($phone) && !empty($phone)) {
                ET_Builder_Element::set_style($render_slug, array(
                    'selector' => $options['selector'],
                    'declaration' => et_builder_get_element_style_css(
                        $phone,
                        $options['type'],
                        $options['important']
                    ),
                    'media_query' => ET_Builder_Element::get_media_query('max_width_767'),
                ));
            }
            if (et_builder_is_hover_enabled($slug, $module->props) && isset($module->props[$slug . '__hover'])) {
                $hover = $module->props[$slug . '__hover'];
                ET_Builder_Element::set_style($render_slug, array(
                    'selector' => $options['hover'],
                    'declaration' => et_builder_get_element_style_css(
                        $hover,
                        $options['type'],
                        $options['important']
                    ),
                ));
            }
        }
    }

    /**
     * Process single value
     */
    static function apply_single_value($options = array())
    {

        $default = array(
            'module'            => '',
            'render_slug'       => '',
            'slug'              => '',
            'type'              => '',
            'selector'          => '',
            'unit'              => '%',
            'hover'             => '',
            'decrease'          => false,
            'addition'          => true,
            'important'         => true,
            'default'           => '14'
        );
        $options        = wp_parse_args($options, $default);
        extract($options);

        // print_r($module->props[$slug]);

        $desktop_value  =  !empty($module->props[$slug]) ? $module->props[$slug] : $default;
        $tablet_value   =  !empty($module->props[$slug . '_tablet']) ? $module->props[$slug . '_tablet'] : $desktop_value;
        $mobile_value   =  !empty($module->props[$slug . '_phone']) ? $module->props[$slug . '_phone'] : $tablet_value;

        $desktop     = $decrease === false ? intval($desktop_value) : 100 - intval($desktop_value);
        $tablet     = $decrease === false ? intval($tablet_value) : 100 - intval($tablet_value);
        $phone         = $decrease === false ? intval($mobile_value) : 100 - intval($mobile_value);
        $negative   = $addition == false ? '-' : '';

        $desktop    .= $unit;
        $tablet     .= $unit;
        $phone      .= $unit;

        if (isset($desktop) && !empty($desktop)) {
            ET_Builder_Element::set_style($render_slug, array(
                'selector' => $selector,
                'declaration' => sprintf('%1$s:%2$s;', $type, $desktop, $negative),
            ));
        }
        if (isset($tablet) && !empty($tablet)) {
            ET_Builder_Element::set_style($render_slug, array(
                'selector' => $selector,
                'declaration' => sprintf('%1$s:%3$s%2$s !important;', $type, $tablet, $negative),
                'media_query' => ET_Builder_Element::get_media_query('max_width_980'),
            ));
        }
        if (isset($phone) && !empty($phone)) {
            ET_Builder_Element::set_style($render_slug, array(
                'selector' => $selector,
                'declaration' => sprintf('%1$s:%3$s%2$s !important;', $type, $phone, $negative),
                'media_query' => ET_Builder_Element::get_media_query('max_width_767'),
            ));
        }
        if (et_builder_is_hover_enabled($slug, $module->props) && isset($module->props[$slug . '__hover'])) {
            $hover_value = $module->props[$slug . '__hover'];
            if (!empty($hover_value)) {
                $hover_value     = $decrease === false ? intval($hover_value) : 100 - intval($hover_value);
                $hover_value .= $unit;
                ET_Builder_Element::set_style($render_slug, array(
                    'selector' => $options['hover'],
                    'declaration' => sprintf('%1$s:%2$s %3$s;', $type, $hover_value, $negative),
                ));
            }
        }
    }

    /**
     * Process color
     */
    static function process_color($options = array())
    {
        $default = array(
            'module'            => '',
            'render_slug'       => '',
            'slug'              => '',
            'type'              => '',
            'selector'          => '',
            'hover'             => '',
            'important'         => true
        );
        $options        = wp_parse_args($options, $default);
        extract($options);

        $key = $module->props[$slug];
        $important_text = true === $important ? '!important' : '';

        if ('' !== $key) {
            ET_Builder_Element::set_style($render_slug, array(
                'selector' => $selector,
                'declaration' => sprintf('%2$s: %1$s %3$s;', $key, $type, $important_text),
            ));
        }
        if (et_builder_is_hover_enabled($slug, $module->props) && isset($module->props[$slug . '__hover'])) {
            $slug_hover = $module->props[$slug . '__hover'];
            ET_Builder_Element::set_style($render_slug, array(
                'selector' => $hover,
                'declaration' => sprintf('%2$s: %1$s %3$s;', $slug_hover, $type, $important_text),
            ));
        }
    }

    /**
     * Process custom background
     */
    static function custom_background_css($options = array())
    {
        $default = array(
            'module'            => '',
            'render_slug'       => '',
            'slug'              => '',
            'selector'          => '',
            'hover'             => '',
            'important'         => true
        );

        $options        = wp_parse_args($options, $default);
        extract($options);

        $background_image = '';
        $gradient = '';
        $important_text = true === $important ? '!important' : '';

        if ($module->props[$slug . '_bgcolor'] !== '') {
            ET_Builder_Element::set_style($render_slug, array(
                'selector' => $selector,
                'declaration' => sprintf(
                    'background-color: %1$s %2$s;',
                    $module->props[$slug . '_bgcolor'],
                    $important_text
                ),
            ));
        }

        if ($module->props[$slug . '_use_gradient'] === 'on') {
            $color_1 = $module->props[$slug . '_color_gradient_1'] != '' ?
                $module->props[$slug . '_color_gradient_1'] : "#2b87da";
            $color_2 = $module->props[$slug . '_color_gradient_2'] != '' ?
                $module->props[$slug . '_color_gradient_2'] : "#29c4a9";
            $linear_direction = $module->props[$slug . '_gradient_direction'] != '' ?
                $module->props[$slug . '_gradient_direction'] : "180deg";
            $start_position = $module->props[$slug . '_start_position'] != '' ?
                $module->props[$slug . '_start_position'] : "0%";
            $end_position = $module->props[$slug . '_end_position'] != '' ?
                $module->props[$slug . '_end_position'] : "100%";
            $radial_direction = $module->props[$slug . '_radial_direction'] ?
                $module->props[$slug . '_radial_direction'] : 'center';

            if ($module->props[$slug . '_gradient_type'] !== 'radial') {
                $gradient = sprintf(
                    'linear-gradient( %3$s, %1$s %4$s, %2$s %5$s)',
                    $color_1,
                    $color_2,
                    $linear_direction,
                    $start_position,
                    $end_position
                );
            } else {
                $gradient = sprintf(
                    'radial-gradient( circle at %3$s, %1$s %4$s, %2$s %5$s)',
                    $color_1,
                    $color_2,
                    // self::dz_process_values($radial_direction),
                    'center',
                    $start_position,
                    $end_position
                );
            }
        }
        // background image
        if ($module->props[$slug . '_background_image'] !== '' || $gradient  !== '') {
            $separator = $module->props[$slug . '_background_image'] !== '' && $gradient  !== '' ? ',' : '';
            $background_image = sprintf('url(%1$s)', $module->props[$slug . '_background_image']);
            ET_Builder_Element::set_style($render_slug, array(
                'selector' => $selector,
                'declaration' => $module->props[$slug . '_above_image'] === 'on' ?
                    sprintf(
                        'background-image:%1$s%4$s %2$s %3$s;',
                        $gradient,
                        $background_image,
                        $important_text,
                        $separator
                    ) : sprintf(
                        'background-image:%2$s%4$s %1$s %3$s;',
                        $gradient,
                        $background_image,
                        $important_text,
                        $separator
                    ),
            ));
        }
        if ($background_image !== '') {
            $background_size = $module->props[$slug . '_background_image_size'] !== '' ?
                $module->props[$slug . '_background_image_size'] : 'cover';
            $background_position = $module->props[$slug . '_background_image_position'] !== '' ?
                $module->props[$slug . '_background_image_position'] : 'center';
            $background_repeat = $module->props[$slug . '_background_image_repeat'] !== '' ?
                $module->props[$slug . '_background_image_repeat'] : 'no_repeat';

            ET_Builder_Element::set_style($render_slug, array(
                'selector' => $selector,
                'declaration' => sprintf(
                    'background-size:%1$s; background-position:%2$s; background-repeat:%3$s;',
                    self::dz_process_values($background_size),
                    self::dz_process_values($background_position),
                    self::dz_process_values($background_repeat)
                ),
            ));
        }

        // hover styles
        if (self::check_hover_enable($slug . '_bgcolor', $module) === true) {
            ET_Builder_Element::set_style($render_slug, array(
                'selector' => $hover,
                'declaration' => sprintf(
                    'background-color: %1$s !important;',
                    $module->props[$slug . '_bgcolor__hover']
                ),
            ));
        }
        if (self::check_hover_enable($slug . '_background_image_size', $module) === true) {
            ET_Builder_Element::set_style($render_slug, array(
                'selector' => $hover,
                'declaration' => sprintf(
                    'background-size: %1$s !important;',
                    $module->props[$slug . '_background_image_size__hover']
                ),
            ));
        }
        if (self::check_hover_enable($slug . '_background_image_position', $module) === true) {
            ET_Builder_Element::set_style($render_slug, array(
                'selector' => $hover,
                'declaration' => sprintf(
                    'background-position: %1$s !important;',
                    $module->props[$slug . '_background_image_position__hover']
                ),
            ));
        }
        if (self::check_hover_enable($slug . '_background_image_repeat', $module) === true) {
            ET_Builder_Element::set_style($render_slug, array(
                'selector' => $hover,
                'declaration' => sprintf(
                    'background-repeat: %1$s !important;',
                    $module->props[$slug . '_background_image_repeat__hover']
                ),
            ));
        }
    }

    /**
     * check hover option
     */
    static function check_hover_enable($key, $module)
    {
        if (isset($module->props[$key . '__hover'])  && et_builder_is_hover_enabled($key, $module->props)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Custom transition to elements
     */
    static function apply_custom_transition($module, $render_slug, $selector, $type = 'all')
    {
        ET_Builder_Element::set_style($render_slug, array(
            'selector' => $selector,
            'declaration' => sprintf(
                'transition:%1$s %2$s %3$s %4$s !important;',
                $type,
                $module->props['hover_transition_duration'],
                $module->props['hover_transition_speed_curve'],
                $module->props['hover_transition_delay']
            ),
        ));
    }

    /**
     * Process values
     */
    static function dz_process_values($value)
    {
        $array = array(
            'center'        => 'center',
            'top_left'      => 'top left',
            'top_center'    => 'top center',
            'center_top'    => 'center top',
            'top'           => 'top',
            'top_right'     => 'top right',
            'right'         => 'right',
            'center_right'  => 'center right',
            'bottom_right'  => 'bottom right',
            'bottom'        => 'bottom',
            'bottom_center' => 'bottom center',
            'bottom_left'   => 'bottom left',
            'left'          => 'left',
            'center_left'   => 'center left',
            'no_repeat'     => 'no-repeat',
            'repeat'        => 'repeat',
            'repeat_x'      => 'repeat-x',
            'repeat_y'      => 'repeat-y',
            'space'         => 'space',
            'round'         => 'round',
            'cover'         => 'cover',
            'fit'           => 'contain',
            'actual_size'   => 'initial'
        );
        return $array[$value];
    }
}
