<?php
/**
 * @Package: WordPress Plugin
 * @Subpackage: Ultra Portfolio
 * @Since: Ultra Portfolio 1.0
 * @Current Version: Ultra Portfolio 3.1
 * @WordPress Version: 3.5 or above
 * This file is part of Ultra Portofolio WordPress Plugin.
 */


/* --------------- Enqueue Library---------------- */
require_once( trailingslashit(dirname(__FILE__)) . '/uport-panel-fields.php' );

/* --------------- Enqueue Library---------------- */
require_once( trailingslashit(dirname(__FILE__)) . '/uport-live-preview.php' );

function uport_panel_steps() {
    echo "<div class='wrap uport-panel-wrap'>";
    if (isset($_GET['id']) && trim($_GET['id']) != "") {
        $id = $_GET['id'];
        echo "<h2 class='uport_head'>";
        echo _e('Edit Portfolio', 'uport-framework');
        ?>
        <a href="<?php echo esc_url(home_url()); ?>/wp-admin/admin.php?page=uport_edit_portfolio" class="add-new-h2"><?php _e('Add New', 'uport-framework'); ?></a>
        <?php
        echo "</h2>";
    } else {
        $id = "";
        echo "<h2 class='uport_head'>";
        echo _e('Add New Portfolio', 'uport-framework');
        echo "</h2>";
    }
    echo "<input type='hidden' name='uport_id' id='uport_id' value='" . $id . "'>";
    $val1arr = uport_get_arr($id, '1');
    $val2arr = uport_get_arr($id, '2');
    $val4arr = uport_get_arr($id, '4');
    $val3arr = uport_get_arr($id, '3');
    $step1_head = "General";
    $step2_head = "Layout";
    $step3_head = "Effect";
    $step4_head = "Live Style";

    $panel_mode = "vertical1";

    if ($panel_mode == "vertical") {

        uport_panel_step1($val1arr, $step1_head);
        uport_panel_step2($val2arr, $step2_head);
        uport_panel_step4($val4arr, $step4_head);
        uport_live_preview($id);
        uport_panel_step3($val3arr, $step3_head);
    } else {

        echo "<div class='uport_tabs'>
    <div data-tabid='1' id='uport1_tab' class='uport_tab active'>" . $step1_head . "</div>
    <div data-tabid='2' id='uport2_tab' class='uport_tab'>" . $step2_head . "</div>
    <div data-tabid='3' id='uport3_tab' class='uport_tab'>" . $step3_head . "</div>
    <div data-tabid='4' id='uport4_tab' class='uport_tab'>" . $step4_head . "</div>
</div>";

        echo "<div class='uport_contents'>";
        echo "<div data-contentid='1' id='uport1_content' class='uport_content active'>";
        uport_panel_step1($val1arr, "");
        echo "</div>";
        echo "<div data-contentid='2' id='uport2_content' class='uport_content '>";
        uport_panel_step2($val2arr, "");
        echo "</div>";
        echo "<div data-contentid='3' id='uport3_content' class='uport_content '>";
        uport_panel_step4($val4arr, "");
        echo "</div>";
        echo "<div data-contentid='4' id='uport4_content' class='uport_content '>";
        uport_panel_step3($val3arr, "");
        echo "</div>";
        echo "</div>";

        uport_live_preview($id);
        uport_save_all_steps();
    }




    /*    $val5arr = uport_get_arr($id, '5');
      $val6arr = uport_get_arr($id, '6');
      $val7arr = uport_get_arr($id, '7');
      uport_panel_step5($val5arr);
      uport_panel_step6($val6arr);
      uport_panel_step7($val7arr); */

    echo "</div>";
}

function uport_save_all_steps() {

    $allfields = uport_fields('step1') . "|" . uport_fields('step2') . "|" . uport_fields('step3') . "|" . uport_fields('step4') . "|";
    echo "<input type='hidden' name='uport_settingids_all' id='uport_settingids_all' value='" . $allfields . "'>";
}

function uport_save_stepall() {
    uport_save_common('all');
}

add_action('wp_ajax_uport_load_step1', 'uport_save_step1');
add_action('wp_ajax_uport_load_step2', 'uport_save_step2');
add_action('wp_ajax_uport_load_step3', 'uport_save_step3');
add_action('wp_ajax_uport_load_step4', 'uport_save_step4');
add_action('wp_ajax_uport_load_stepall', 'uport_save_stepall');

function uport_panel_step1($valarr, $step_head = "") {
    $catids = "0:Select (multi)|".uport_catstrs('str');
    $woocatids = "0:Select (multi)|".uport_woocatstrs('str');
    $sortitemsby = "default:Default Order of Item Addition|desc:Newest First Order of Item Addition|title:Item Title (Ascending Alphabetical (A-Z) Order)|titledesc:Item Title (Descending Alphabetical (Z-A) Order)|custom:Custom Order (Manual Drag and Drop)";

    $stepclass = " uport_1_field ";

    echo "<h3>" . $step_head . "<div class='uport_save_msg_step1 uport_save_msg'></div></h3>
    <form action='javascript:void();' class='formwrap'><table border=0 class='formtable'><tr class='trspacer'><td colspan=5></td></tr>";
    /* uport_field('Portfolio ID', 'portid', 'integer', '', '', 'Unique id for identification. Should contain alphanumeric characters only (A-Z, a-z and 0-9). Eg: port01', '1', $valarr,$stepclass); */
    uport_field('Portfolio Name', 'name', 'text', '', '', 'Unique Portfolio name (for identification purpose only).', '1', $valarr, $stepclass);
    uport_field('Portfolio Categories', 'categories', 'select_multi', '', $catids, 'Pick categories to display portfolio items from.', '1', $valarr, $stepclass." uport-combobox-multi ");
    uport_field('WooCommerce Categories', 'woocategories', 'select_multi', '', $woocatids, 'Pick WooCommerce categories to display portfolio items from.', '1', $valarr, $stepclass." uport-combobox-multi ");
    uport_field('Maximum Portfolio Items', 'maxitems', 'text', '', '', 'Enter maximum number of portfolio items to show in a portfolio.', '1', $valarr, $stepclass);
    uport_field('Sort Portfolio Items By', 'sortitemsby', 'select', 'title', $sortitemsby, 'Select the sorting type of portfolio items.', '1', $valarr, $stepclass." ");
    uport_field('', 'sortitemslist', 'sortlist', '', '', '', '1', $valarr, $stepclass." ");

    echo uport_ajax_save_row('1');

    //echo "<tr><td colspan=3><div id='uport_items_sortable'></div></td></tr>";

    echo "<input type='hidden' name='uport_settingids_1' id='uport_settingids_1' value='" . uport_fields('step1') . "'></table></form>";
}

function uport_save_step1() {
    uport_save_common('1');
}

/* * *************************************************************** */

function uport_panel_step2($valarr, $step_head = "") {

    $stepclass = " uport_2_field ";

    echo "<h3>" . $step_head . " <div class='uport_save_msg_step2 uport_save_msg'></div></h3>
<form action='javascript:void();' class='formwrap'><table border=0 class='formtable'><tr class='trspacer'><td colspan=5></td></tr>";

    uport_field('Pick Type', 'uporttype', 'select', 'grid', 'grid:Grid|masonary:Masonary|slider:Slider|single:Single Slider', 'Pick the type of layout for portfolio.', '1', $valarr, $stepclass." has_dependent ");

    uport_field('Filter Categories', 'catshow', 'select', 'show', 'show:Show|hide:Don&apos;t Show', 'Show Portfolio Categories or not for filtering.', '1', $valarr, $stepclass,""," is_dependent dependent_on_uporttype uporttype_grid uporttype_masonary ");

    uport_field('No. of columns', '', 'rowstart', '', '', 'Pick responsive columns for different devices', '0', $valarr, $stepclass);
    uport_field('Large screens', 'noofcolumns1', 'integer_multi', '', '', '', '0', $valarr, $stepclass);
    uport_field('Medium screens', 'noofcolumns2', 'integer_multi', '', '', '', '0', $valarr, $stepclass);
    uport_field('Small screens', 'noofcolumns3', 'integer_multi', '', '', '', '0', $valarr, $stepclass);
    uport_field('Extra Small screens', 'noofcolumns4', 'integer_multi', '', '', '', '0', $valarr, $stepclass);
    uport_field('', '', 'rowend', '', '', 'Responsive Portfolio number of columns for various resolutions like desktop, laptop, mobile, smartphones etc.', '0', $valarr," clearfix ");

    uport_field('Items Spacing<br>(on all 4 sides)', '', 'rowstart', '', '', '', '0', $valarr);
    uport_field('Top', 'margintop', 'integer_multi', '', '', '', '0', $valarr, $stepclass);
    uport_field('Right', 'marginright', 'integer_multi', '', '', '', '0', $valarr, $stepclass);
    uport_field('Bottom', 'marginbottom', 'integer_multi', '', '', '', '0', $valarr, $stepclass);
    uport_field('Left', 'marginleft', 'integer_multi', '', '', '', '0', $valarr, $stepclass);
    uport_field('', '', 'rowend', '', '', 'Spacing among items on all four sides. Eg: 21 21 0 0', '0', $valarr," clearfix ");

    $detailids = uport_item_element_list('str');
    //$detailids = "image: Thumbnail image|title:Title|desc:Small Description|linkbut: URL Link button (on hover)|lightbox: Lightbox pop up button|slug: Other like date or tagline";
    uport_field('Item details to show', 'showdetails', 'elementlist', '', $detailids, 'Checked things will be displayed for each item in portfolio.', '1', $valarr, $stepclass);

    $detailids = "bottom:Default (Out area is below image)|left:Left (Out area is on left of image)|right:Right (Out area is on right of image)";
    uport_field('Out Area Position', 'outerstyle', 'select', 'bottom', $detailids, 'Pick the outer area content position in item relative to item image/media.', '1', $valarr, $stepclass);


    uport_field('Character Length', '', 'rowstart', '', '', '', '0', $valarr, $stepclass);
    uport_field('Title', 'lengthtitle', 'integer_multi', '', '', '', '0', $valarr, $stepclass);
    uport_field('Description', 'lengthdesc', 'integer_multi', '', '', '', '0', $valarr, $stepclass);
    uport_field('', '', 'rowend', '', '', 'Set maximum characters to display for title and description in integer. Eg: 20,50', '0', $valarr," clearfix ");


    $detailids = "true: As URL link|false: As Text Only";
    uport_field('Show Title as', 'titletype', 'select', 'true', $detailids, 'Show portfolio item title as link or only text.', '1', $valarr, $stepclass);

    $detailids = "same: Same Tab|new: New Tab";
    uport_field('Open URL Link in', 'linktarget', 'select', 'same', $detailids, 'Pick to open portfolio link in same window tab or new one.', '1', $valarr, $stepclass);

    $detailids = "icon: Icon|text: Text";
    uport_field('Show URL Link as', '', 'rowstart', '', '', '', '0', $valarr, $stepclass);
    uport_field('', 'linktype', 'select', 'icon', $detailids, '', '0', $valarr, $stepclass);
    uport_field('', 'linktext', 'integer', '', '', '', '0', $valarr, $stepclass,"placeholder='Enter text'");
    uport_field('', '', 'rowend', '', '', 'Show URL link as icon or defined text.', '0', $valarr);

    $detailids = "icon: Icon|text: Text";
    uport_field('Show Lightbox button as', '', 'rowstart', '', '', '', '0', $valarr, $stepclass);
    uport_field('', 'lightboxtype', 'select', 'icon', $detailids, '', '0', $valarr, $stepclass);
    uport_field('', 'lightboxtext', 'integer', '', '', '', '0', $valarr, $stepclass,"placeholder='Enter text'");
    uport_field('', '', 'rowend', '', '', 'Show Lightbox pop up button as icon or defined text.', '0', $valarr);

    $detailids = "icon: Icon|text: Text";
    uport_field('Show Cart button as', '', 'rowstart', '', '', '', '0', $valarr, $stepclass);
    uport_field('', 'carttype', 'select', 'icon', $detailids, '', '0', $valarr, $stepclass);
    uport_field('', 'carttext', 'integer', '', '', '', '0', $valarr, $stepclass,"placeholder='Enter text'");
    uport_field('', '', 'rowend', '', '', 'Show add to cart button as icon or defined text.', '0', $valarr);

    $detailids = "both: Regular & Sale Price|onlysale: Only Sale Price|onlyregular: Only Regular Price|onlyone: Only one price [Sale Price(if present) or Regular Price]";
    uport_field('Show Price as', 'pricetype', 'select', 'both', $detailids, 'Show WooCommerce portfolio item price as sale price or regular price or both prices.', '1', $valarr, $stepclass);

    $detailids = "date:Item Date|category:Category|slug:Defined Text";
    uport_field('Slug or Tagline', 'slugtype', 'select', 'slug', $detailids, 'Show date, category or define slug tagline in slug area of portfolio. This is applicable only if slug option is selected in item details to show above.', '1', $valarr, $stepclass);

    $detailids = "title:Show Item Title|category:Display Category|desc:Small Text|";
    uport_field('Lightbox caption area', 'lightboxcaption', 'select_multi', 'title', $detailids, 'Choose to show item title, category, small description below lightbox pop up box (in caption area)', '1', $valarr, $stepclass." uport-combobox-multi ");

    uport_field('Image Width', 'imagewidth', 'integer', '', '', 'Mention width of images loaded in portfolio. (New image will be created if the mentioned dimension is not found). Leave blank for auto. Value is in pixels. Eg: 400', '1', $valarr, $stepclass);
    uport_field('Image Height', 'imageheight', 'integer', '', '', 'Mention height of images loaded in portfolio. (New image will be created if the mentioned dimension is not found). Leave blank for auto. Value is in pixels. Eg: 400', '1', $valarr, $stepclass);

    $detailids = "true: Hard Crop|false: Soft Crop";
    uport_field('Image Crop', 'imagecrop', 'select', 'false', $detailids, 'New image created will be cropped softly or hardly. Soft crop keeps the any one dimension as auto and simply resizes a image to mentioned width (priority) or height. Hard Crop will cut the image to mentioned dimensions strictly. Resize only works for media library images.', '1', $valarr, $stepclass);

    $detailids = "true: Resize to larger dimension|false: Use original image and don&apos;t resize.";
    uport_field('Image Upscale resize', 'imageupscale', 'select', 'false', $detailids, 'If the original portfolio item image is smaller than mentioned dimensions, then select to use the original image or resize to large dimension.', '1', $valarr, $stepclass);

    uport_field('Minimum Width', 'minwidth', 'integer', '', '', 'Mention minimum portfolio width. Leave blank for 100%. Eg: 400,80%,500px', '1', $valarr, $stepclass);
    uport_field('Maximum Width', 'maxwidth', 'integer', '', '', 'Mention maximum portfolio width. Leave blank for 100%. Eg: 400,80%,500px', '1', $valarr, $stepclass);


    echo uport_ajax_save_row('2');

    echo "<input type='hidden' name='uport_settingids_2' id='uport_settingids_2' value='" . uport_fields('step2') . "'></table></form>";
}

function uport_save_step2() {
//if( !isset( $_POST['uport_nonce'] ) || !wp_verify_nonce($_POST['uport_nonce'], 'uport-nonce') ){die('Permissions check failed. Please login or refresh (if already logged in) the page, then try Again.');}
//print_r($_POST);
//echo "Ajax done 2";
//die();
    uport_save_common('2');
}

/* * *************************************************************** */

function uport_panel_step3($valarr, $step_head = "") {

    include("uport-gfonts.php");

    $stepclass = " uport_3_field ";

    echo "<h3>" . $step_head . " <div class='uport_save_msg_step3 uport_save_msg'></div></h3>
<form action='javascript:void();' class='formwrap'>

<div class='csstabs_links'>
    <div id='csstitletab' class='csstabs active'>Title</div>
    <div id='cssdesctab' class='csstabs'>Description</div>
    <div id='cssslugtab' class='csstabs'>Slug</div>
    <div id='cssbuttab' class='csstabs'>Button</div>
    <div id='cssbg' class='csstabs'>Background</div>
    <div id='cssborder' class='csstabs'>Border & Shadow</div>
    <div id='csscat' class='csstabs'>Categories</div>
    <div id='cssabovetab' class='csstabs'>Above Media Layer</div>
    <div id='csspricetab' class='csstabs'>Price</div>
</div>
<div class='csstabs_data'>


<table border=0 class='formtable'><tr class='trspacer'><td colspan=5></td></tr>";



    uport_field('Title Style', '', 'rowstart', '', '', '', '0', $valarr, 'csstabs csstitletab active');

    echo "<div class='uport-accordion'>";
    
        echo "<div class='group'><h4>Color</h4><div>";
            uport_field('Color', 'titlecolor', 'color', '', '', '', '0', $valarr, 'livetitle ' . $stepclass . ' ');
            uport_field('Background', 'titlebgcolor', 'color', '', '', '', '0', $valarr, 'livetitle ' . $stepclass . ' ');
        echo "</div></div>";

        echo "<div class='group'><h4>Font</h4><div>";
            uport_field('Font', 'titlefontname', 'select', 'Open Sans', $fontlist, '', '0', $valarr, 'livetitle ' . $stepclass . ' uport-combobox');
            uport_field('Font Backup', 'titlefontbackup', 'select', '', $fontbackuplist, '', '0', $valarr, 'livetitle ' . $stepclass . ' uport-combobox');
            uport_field('Font Weight & Style', 'titlefontweight', 'select', 'Open Sans', $fontweightlist, '', '0', $valarr, 'livetitle ' . $stepclass . ' uport-combobox');
            uport_field('Font Subset', 'titlefontsubset', 'select', 'Latin', $fontsubsetlist, '', '0', $valarr, 'livetitle ' . $stepclass . ' uport-combobox');
            uport_field('Font Size', 'titlefontsize', 'integer', '', '', '', '0', $valarr, 'livetitle ' . $stepclass . '  uport-spinner');
            uport_field('Align', 'titlealign', 'select', 'center', 'center:Center|left:Left|right:Right', '', '0', $valarr, 'livetitle ' . $stepclass . ' ');
            uport_field('Line Height', 'titlelineheight', 'integer', '', '', '', '0', $valarr, 'livetitle ' . $stepclass . '  uport-spinner');
        echo "</div></div>";

        echo "<div class='group'><h4>Spacing</h4><div>";
            uport_field('Padding:', '', 'label', '', '', '', '0', $valarr);
            uport_field('Top', 'titlepaddingtop', 'integer_label', '', '', '', '0', $valarr, 'livetitle ' . $stepclass . '  uport-spinner');
            uport_field('Right', 'titlepaddingright', 'integer_label', '', '', '', '0', $valarr, 'livetitle ' . $stepclass . '  uport-spinner');
            uport_field('Bottom', 'titlepaddingbottom', 'integer_label', '', '', '', '0', $valarr, 'livetitle ' . $stepclass . '  uport-spinner');
            uport_field('Left', 'titlepaddingleft', 'integer_label', '', '', '', '0', $valarr, 'livetitle ' . $stepclass . '  uport-spinner');
            uport_field('', '', 'labelend', '', '', '', '0', $valarr);

            uport_field('Margin:', '', 'label', '', '', '', '0', $valarr);
            uport_field('Top', 'titlemargintop', 'integer_label', '', '', '', '0', $valarr, 'livetitle ' . $stepclass . '  uport-spinner');
            uport_field('Right', 'titlemarginright', 'integer_label', '', '', '', '0', $valarr, 'livetitle ' . $stepclass . '  uport-spinner');
            uport_field('Bottom', 'titlemarginbottom', 'integer_label', '', '', '', '0', $valarr, 'livetitle ' . $stepclass . '  uport-spinner');
            uport_field('Left', 'titlemarginleft', 'integer_label', '', '', '', '0', $valarr, 'livetitle ' . $stepclass . '  uport-spinner');
            uport_field('', '', 'labelend', '', '', '', '0', $valarr);
        echo "</div></div>";

    echo "</div>";


    uport_field('', '', 'rowend', '', '', 'Set font name, size, color, alignment, bold, italic line height of title of item. All numeric values are by default in pixels Eg: 5 will be treated as 5px. You can enter values in %,em too. <strong>Eg: 1em, 5%, 10px, 10</strong>', '0', $valarr);


    uport_field('Description Style', '', 'rowstart', '', '', '', '0', $valarr, 'csstabs cssdesctab');


    echo "<div class='uport-accordion'>";
    
        echo "<div class='group'><h4>Color</h4><div>";
            uport_field('Color', 'desccolor', 'color', '', '', '', '0', $valarr, 'livedesc ' . $stepclass . ' ');
            uport_field('Background', 'descbgcolor', 'color', '', '', '', '0', $valarr, 'livedesc ' . $stepclass . ' ');
        echo "</div></div>";

        echo "<div class='group'><h4>Font</h4><div>";
            uport_field('Font', 'descfontname', 'select', 'Open Sans', $fontlist, '', '0', $valarr, 'livedesc ' . $stepclass . ' uport-combobox');
            uport_field('Backup Font', 'descfontbackup', 'select', 'Open Sans', $fontbackuplist, '', '0', $valarr, 'livedesc ' . $stepclass . ' uport-combobox');
            uport_field('Font Weight & Style', 'descfontweight', 'select', 'Open Sans', $fontweightlist, '', '0', $valarr, 'livedesc ' . $stepclass . ' uport-combobox');
            uport_field('Font Subset', 'descfontsubset', 'select', 'Latin', $fontsubsetlist, '', '0', $valarr, 'livedesc ' . $stepclass . ' uport-combobox');
            uport_field('Font Size', 'descfontsize', 'integer', '', '', '', '0', $valarr, 'livedesc ' . $stepclass . ' uport-spinner');
            uport_field('Align', 'descalign', 'select', 'center', 'center:Center|left:Left|right:Right', '', '0', $valarr, 'livedesc ' . $stepclass . ' ');
            uport_field('Line Height', 'desclineheight', 'integer', '', '', '', '0', $valarr, 'livedesc ' . $stepclass . ' uport-spinner');
        echo "</div></div>";

        echo "<div class='group'><h4>Spacing</h4><div>";
            uport_field('Padding:', '', 'label', '', '', '', '0', $valarr);
                uport_field('Top', 'descpaddingtop', 'integer_label', '', '', '', '0', $valarr, 'livedesc ' . $stepclass . ' uport-spinner');
                uport_field('Right', 'descpaddingright', 'integer_label', '', '', '', '0', $valarr, 'livedesc ' . $stepclass . ' uport-spinner');
                uport_field('Bottom', 'descpaddingbottom', 'integer_label', '', '', '', '0', $valarr, 'livedesc ' . $stepclass . ' uport-spinner');
                uport_field('Left', 'descpaddingleft', 'integer_label', '', '', '', '0', $valarr, 'livedesc ' . $stepclass . ' uport-spinner');
            uport_field('', '', 'labelend', '', '', '', '0', $valarr);

            uport_field('Margin:', '', 'label', '', '', '', '0', $valarr);
                uport_field('Top', 'descmargintop', 'integer_label', '', '', '', '0', $valarr, 'livedesc ' . $stepclass . ' uport-spinner');
                uport_field('Right', 'descmarginright', 'integer_label', '', '', '', '0', $valarr, 'livedesc ' . $stepclass . ' uport-spinner');
                uport_field('Bottom', 'descmarginbottom', 'integer_label', '', '', '', '0', $valarr, 'livedesc ' . $stepclass . ' uport-spinner');
                uport_field('Left', 'descmarginleft', 'integer_label', '', '', '', '0', $valarr, 'livedesc ' . $stepclass . ' uport-spinner');
            uport_field('', '', 'labelend', '', '', '', '0', $valarr);

        echo "</div></div>";

    echo "</div>";

    uport_field('', '', 'rowend', '', '', 'Set font name, size, color, alignment, bold, italic line height of title of item. All numeric values are by default in pixels Eg: 5 will be treated as 5px. You can enter values in %,em too. <strong>Eg: 1em, 5%, 10px, 10</strong>', '0', $valarr);




    uport_field('Slug Style', '', 'rowstart', '', '', '', '0', $valarr, 'csstabs cssslugtab');

    echo "<div class='uport-accordion'>";
    
        echo "<div class='group'><h4>Color</h4><div>";
            uport_field('Color', 'slugcolor', 'color', '', '', '', '0', $valarr, 'liveslug ' . $stepclass . ' ');
            uport_field('Background', 'slugbgcolor', 'color', '', '', '', '0', $valarr, 'liveslug ' . $stepclass . ' ');
        echo "</div></div>";

        echo "<div class='group'><h4>Font</h4><div>";
            uport_field('Font', 'slugfontname', 'select', 'Open Sans', $fontlist, '', '0', $valarr, 'liveslug ' . $stepclass . ' uport-combobox');
            uport_field('Backup Font', 'slugfontbackup', 'select', 'Open Sans', $fontbackuplist, '', '0', $valarr, 'liveslug ' . $stepclass . ' uport-combobox');
            uport_field('Font Weight & Style', 'slugfontweight', 'select', 'Open Sans', $fontweightlist, '', '0', $valarr, 'liveslug ' . $stepclass . ' uport-combobox');
            uport_field('Font Subset', 'slugfontsubset', 'select', 'Latin', $fontsubsetlist, '', '0', $valarr, 'liveslug ' . $stepclass . ' uport-combobox');
            uport_field('Font Size', 'slugfontsize', 'integer', '', '', '', '0', $valarr, 'liveslug ' . $stepclass . ' uport-spinner');
            uport_field('Align', 'slugalign', 'select', 'center', 'center:Center|left:Left|right:Right', '', '0', $valarr, 'liveslug ' . $stepclass . ' ');
            uport_field('Line Height', 'sluglineheight', 'integer', '', '', '', '0', $valarr, 'liveslug ' . $stepclass . ' uport-spinner');
        echo "</div></div>";

        echo "<div class='group'><h4>Spacing</h4><div>";
            uport_field('Padding:', '', 'label', '', '', '', '0', $valarr);
                uport_field('Top', 'slugpaddingtop', 'integer_label', '', '', '', '0', $valarr, 'liveslug ' . $stepclass . ' uport-spinner');
                uport_field('Right', 'slugpaddingright', 'integer_label', '', '', '', '0', $valarr, 'liveslug ' . $stepclass . ' uport-spinner');
                uport_field('Bottom', 'slugpaddingbottom', 'integer_label', '', '', '', '0', $valarr, 'liveslug ' . $stepclass . ' uport-spinner');
                uport_field('Left', 'slugpaddingleft', 'integer_label', '', '', '', '0', $valarr, 'liveslug ' . $stepclass . ' uport-spinner');
            uport_field('', '', 'labelend', '', '', '', '0', $valarr);

            uport_field('Margin:', '', 'label', '', '', '', '0', $valarr);
                uport_field('Top', 'slugmargintop', 'integer_label', '', '', '', '0', $valarr, 'liveslug ' . $stepclass . ' uport-spinner');
                uport_field('Right', 'slugmarginright', 'integer_label', '', '', '', '0', $valarr, 'liveslug ' . $stepclass . ' uport-spinner');
                uport_field('Bottom', 'slugmarginbottom', 'integer_label', '', '', '', '0', $valarr, 'liveslug ' . $stepclass . ' uport-spinner');
                uport_field('Left', 'slugmarginleft', 'integer_label', '', '', '', '0', $valarr, 'liveslug ' . $stepclass . ' uport-spinner');
            uport_field('', '', 'labelend', '', '', '', '0', $valarr);
        echo "</div></div>";

    echo "</div>";

    uport_field('', '', 'rowend', '', '', 'Set font name, size, color, alignment, bold, italic line height of title of item. All numeric values are by default in pixels Eg: 5 will be treated as 5px. You can enter values in %,em too. <strong>Eg: 1em, 5%, 10px, 10</strong>', '0', $valarr);






    uport_field('Button Style', '', 'rowstart', '', '', '', '0', $valarr, 'csstabs cssbuttab');

    echo "<div class='uport-accordion'>";
    
        echo "<div class='group'><h4>Color</h4><div>";
            uport_field('Color', 'butcolor', 'color', '', '', '', '0', $valarr, 'livebut ' . $stepclass . ' ');
            uport_field('Background', 'butbgcolor', 'color', '', '', '', '0', $valarr, 'livebut ' . $stepclass . ' ');
            uport_field('Background (hover)', 'butbgcolor2', 'color', '', '', '', '0', $valarr, 'livebuthover ' . $stepclass . ' ');
        echo "</div></div>";

        echo "<div class='group'><h4>Font</h4><div>";
            uport_field('Font', 'butfontname', 'select', 'Open Sans', $fontlist, '', '0', $valarr, 'livebut ' . $stepclass . ' uport-combobox');
            uport_field('Backup Font', 'butfontbackup', 'select', 'Open Sans', $fontbackuplist, '', '0', $valarr, 'livebut ' . $stepclass . ' uport-combobox');
            uport_field('Font Weight & Style', 'butfontweight', 'select', 'Open Sans', $fontweightlist, '', '0', $valarr, 'livebut ' . $stepclass . ' uport-combobox');
            uport_field('Font Subset', 'butfontsubset', 'select', 'Latin', $fontsubsetlist, '', '0', $valarr, 'livebut ' . $stepclass . ' uport-combobox');
            uport_field('Font Size', 'butfontsize', 'integer', '', '', '', '0', $valarr, 'livebut ' . $stepclass . ' uport-spinner');
            uport_field('Align', 'butalign', 'select', 'center', 'center:Center|left:Left|right:Right', '', '0', $valarr, 'livebut ' . $stepclass . ' ');
            uport_field('Line Height', 'butlineheight', 'integer', '', '', '', '0', $valarr, 'livebut ' . $stepclass . ' uport-spinner');
        echo "</div></div>";

        echo "<div class='group'><h4>Spacing</h4><div>";
            uport_field('Padding:', '', 'label', '', '', '', '0', $valarr);
                uport_field('Top', 'butpaddingtop', 'integer_label', '', '', '', '0', $valarr, 'livebut ' . $stepclass . ' uport-spinner');
                uport_field('Right', 'butpaddingright', 'integer_label', '', '', '', '0', $valarr, 'livebut ' . $stepclass . ' uport-spinner');
                uport_field('Bottom', 'butpaddingbottom', 'integer_label', '', '', '', '0', $valarr, 'livebut ' . $stepclass . ' uport-spinner');
                uport_field('Left', 'butpaddingleft', 'integer_label', '', '', '', '0', $valarr, 'livebut ' . $stepclass . ' uport-spinner');
            uport_field('', '', 'labelend', '', '', '', '0', $valarr);

            uport_field('Margin:', '', 'label', '', '', '', '0', $valarr);
                uport_field('Top', 'butmargintop', 'integer_label', '', '', '', '0', $valarr, 'livebut ' . $stepclass . ' uport-spinner');
                uport_field('Right', 'butmarginright', 'integer_label', '', '', '', '0', $valarr, 'livebut ' . $stepclass . ' uport-spinner');
                uport_field('Bottom', 'butmarginbottom', 'integer_label', '', '', '', '0', $valarr, 'livebut ' . $stepclass . ' uport-spinner');
                uport_field('Left', 'butmarginleft', 'integer_label', '', '', '', '0', $valarr, 'livebut ' . $stepclass . ' uport-spinner');
            uport_field('', '', 'labelend', '', '', '', '0', $valarr);
        echo "</div></div>";

        echo "<div class='group'><h4>Border</h4><div>";
            uport_field('Border Color', 'butbordercolor', 'color', '', '', '', '0', $valarr, 'livebut ' . $stepclass . ' ');
            uport_field('Border Width', 'butborderwidth', 'integer', '', '', '', '0', $valarr, 'livebut ' . $stepclass . ' uport-spinner');
            uport_field('Border Radius', 'butborderradius', 'text', '', '', '', '0', $valarr, 'livebut ' . $stepclass . ' uport-spinner');
        echo "</div></div>";

    echo "</div>";

    uport_field('', '', 'rowend', '', '', 'Set font name, size, color, alignment, bold, italic line height of title of item. All numeric values are by default in pixels Eg: 5 will be treated as 5px. You can enter values in %,em too. <strong>Eg: 1em, 5%, 10px, 10</strong>. For Border radius, you can also enter 4 corner radius individually like eg: 50% 10% 40% 50% to make unique rounded corners and shapes.', '0', $valarr);




    uport_field('Background', '', 'rowstart', '', '', '', '0', $valarr, 'csstabs cssbg');

    echo "<div class='uport-accordion'>";

        echo "<div class='group'><h4>Main Portfolio</h4><div>";
            uport_field('Color', 'portbgcolor', 'color', '', '', '', '0', $valarr, 'liveportbg ' . $stepclass . ' ');
            uport_field('Opacity', 'portbgopacity', 'integer', '', '', '', '0', $valarr, 'liveportbg ' . $stepclass . ' uport-spinner-opacity');

            uport_field('Padding:', '', 'label', '', '', '', '0', $valarr);
            uport_field('Top', 'portpaddingtop', 'integer_label', '', '', '', '0', $valarr, 'liveportbg ' . $stepclass . '  uport-spinner');
            uport_field('Right', 'portpaddingright', 'integer_label', '', '', '', '0', $valarr, 'liveportbg ' . $stepclass . '  uport-spinner');
            uport_field('Bottom', 'portpaddingbottom', 'integer_label', '', '', '', '0', $valarr, 'liveportbg ' . $stepclass . '  uport-spinner');
            uport_field('Left', 'portpaddingleft', 'integer_label', '', '', '', '0', $valarr, 'liveportbg ' . $stepclass . '  uport-spinner');
            uport_field('', '', 'labelend', '', '', '', '0', $valarr);

            uport_field('Margin:', '', 'label', '', '', '', '0', $valarr);
            uport_field('Top', 'portmargintop', 'integer_label', '', '', '', '0', $valarr, 'liveportbg ' . $stepclass . '  uport-spinner');
            uport_field('Right', 'portmarginright', 'integer_label', '', '', '', '0', $valarr, 'liveportbg ' . $stepclass . '  uport-spinner');
            uport_field('Bottom', 'portmarginbottom', 'integer_label', '', '', '', '0', $valarr, 'liveportbg ' . $stepclass . '  uport-spinner');
            uport_field('Left', 'portmarginleft', 'integer_label', '', '', '', '0', $valarr, 'liveportbg ' . $stepclass . '  uport-spinner');
            uport_field('', '', 'labelend', '', '', '', '0', $valarr);

        echo "</div></div>";

        echo "<div class='group'><h4>Overlay layer (visible on mouse hover)</h4><div>";
            uport_field('Color', 'bgcolor', 'color', '', '', '', '0', $valarr, 'livemaskbg ' . $stepclass . ' ');
            uport_field('Opacity', 'bgopacity', 'integer', '', '', '', '0', $valarr, 'livemaskbg ' . $stepclass . ' uport-spinner-opacity');
        echo "</div></div>";

        echo "<div class='group'><h4>Portfolio Item</h4><div>";
            uport_field('Color', 'outbgcolor', 'color', '', '', '', '0', $valarr, 'liveoutbg ' . $stepclass . ' ');
            uport_field('Opacity', 'outbgopacity', 'integer', '', '', '', '0', $valarr, 'liveoutbg ' . $stepclass . '  uport-spinner-opacity ');
        echo "</div></div>";

    echo "</div>";

    uport_field('', '', 'rowend', '', '', 'Pick background color and its opacity. Overlay background layer is visible on mouse hover. Surface background is the background of item. Applicable for Outer based styles only. Eg: color as #eeeeee,white and opacity as 0.8 (from 0.0 to 1.0)', '0', $valarr);






    uport_field('Border & Shadow', '', 'rowstart', '', '', '', '0', $valarr, 'csstabs cssborder');

    echo "<div class='uport-accordion'>";
    
        echo "<div class='group'><h4>Border</h4><div>";
            uport_field('Color', 'bordercolor', 'color', '', '', '', '0', $valarr, 'liveborder ' . $stepclass . ' ');
            uport_field('Width', 'borderwidth', 'integer', '', '', '', '0', $valarr, 'liveborder ' . $stepclass . ' uport-spinner');
            //uport_field('Radius', 'borderradius', 'text', '', '', '', '0', $valarr, 'liveborder ' . $stepclass . '  uport-spinner');
        echo "</div></div>";

        echo "<div class='group'><h4>Shadow</h4><div>";
            uport_field('Horizontal', 'hshadow', 'integer', '', '', '', '0', $valarr, 'liveshadow ' . $stepclass . ' uport-spinner');
            uport_field('Vertical', 'vshadow', 'integer', '', '', '', '0', $valarr, 'liveshadow ' . $stepclass . ' uport-spinner');
            uport_field('Blur', 'shadowblur', 'integer', '', '', '', '0', $valarr, 'liveshadow ' . $stepclass . ' uport-spinner');
            uport_field('Spread', 'shadowspread', 'integer', '', '', '', '0', $valarr, 'liveshadow ' . $stepclass . ' uport-spinner');
            uport_field('Color', 'shadowcolor', 'color', '', '', '', '0', $valarr, 'liveshadow ' . $stepclass . ' ');
            //uport_field('Position', 'shadowpos', 'select', 'outset', 'inset:Inset|outset:Outset', '', '0', $valarr, 'liveshadow ' . $stepclass . ' ');
        echo "</div></div>";

    echo "</div>";

    uport_field('', '', 'rowend', '', '', 'Set border radius in percentage/pixel (eg: 50%,5), color and width in pixel of item. Width is in pixels, so enter only integer value (no unit) eg: 5,<br>Radius can be in % or px. So enter unit too. Eg: 50%, 10px. You can also enter 4 corner radius individually like eg: 50% 10% 40% 50% to make unique rounded corners and shapes.<br>Set shadow properties of item. All numeric values are in pixels. <strong>Enter only integer (no unit)</strong>', '0', $valarr);





    uport_field('Filter Categories Style', '', 'rowstart', '', '', '', '0', $valarr, 'csstabs csstabs csscat');

    echo "<div class='uport-accordion'>";
    
        echo "<div class='group'><h4>Color</h4><div>";
            uport_field('Font Color', 'catcolor', 'color', '', '', '', '0', $valarr, 'livecatli ' . $stepclass . ' ');
            uport_field('Background', 'catbgcolor', 'color', '', '', '', '0', $valarr, 'livecatli ' . $stepclass . ' ');
            uport_field('Background (hover)', 'catbgactcolor', 'color', '', '', '', '0', $valarr, 'livecatlihover ' . $stepclass . ' ');
        echo "</div></div>";

        echo "<div class='group'><h4>Font</h4><div>";

            uport_field('Font', 'catfontname', 'select', 'Open Sans', $fontlist, '', '0', $valarr, 'livecatli ' . $stepclass . ' uport-combobox');
            uport_field('Backup Font', 'catfontbackup', 'select', 'Open Sans', $fontbackuplist, '', '0', $valarr, 'livecatli ' . $stepclass . ' uport-combobox');
            uport_field('Font Weight & Style', 'catfontweight', 'select', 'Open Sans', $fontweightlist, '', '0', $valarr, 'livecatli ' . $stepclass . ' uport-combobox');
            uport_field('Font Subset', 'catfontsubset', 'select', 'Latin', $fontsubsetlist, '', '0', $valarr, 'livecatli ' . $stepclass . ' uport-combobox');
            uport_field('Font Size', 'catfontsize', 'integer', '', '', '', '0', $valarr, 'livecatli ' . $stepclass . ' uport-spinner');
            uport_field('Line Height', 'catlineheight', 'integer', '', '', '', '0', $valarr, 'livecatli ' . $stepclass . ' uport-spinner');
            uport_field('Align', 'catalign', 'select', 'center', 'center:Center|left:Left|right:Right', '', '0', $valarr, 'livecatul ' . $stepclass . ' ');
        echo "</div></div>";

        echo "<div class='group'><h4>Spacing</h4><div>";
            uport_field('Padding:', '', 'label', '', '', '', '0', $valarr);
                uport_field('Top', 'catpaddingtop', 'integer_label', '', '', '', '0', $valarr, 'livecatli ' . $stepclass . ' uport-spinner');
                uport_field('Right', 'catpaddingright', 'integer_label', '', '', '', '0', $valarr, 'livecatli ' . $stepclass . ' uport-spinner');
                uport_field('Bottom', 'catpaddingbottom', 'integer_label', '', '', '', '0', $valarr, 'livecatli ' . $stepclass . ' uport-spinner');
                uport_field('Left', 'catpaddingleft', 'integer_label', '', '', '', '0', $valarr, 'livecatli ' . $stepclass . ' uport-spinner');
            uport_field('', '', 'labelend', '', '', '', '0', $valarr);
            uport_field('Margin:', '', 'label', '', '', '', '0', $valarr);
                uport_field('Top', 'catmargintop', 'integer_label', '', '', '', '0', $valarr, 'livecatli ' . $stepclass . ' uport-spinner');
                uport_field('Right', 'catmarginright', 'integer_label', '', '', '', '0', $valarr, 'livecatli ' . $stepclass . ' uport-spinner');
                uport_field('Bottom', 'catmarginbottom', 'integer_label', '', '', '', '0', $valarr, 'livecatli ' . $stepclass . ' uport-spinner');
                uport_field('Left', 'catmarginleft', 'integer_label', '', '', '', '0', $valarr, 'livecatli ' . $stepclass . ' uport-spinner');
            uport_field('', '', 'labelend', '', '', '', '0', $valarr);
        echo "</div></div>";

        echo "<div class='group'><h4>Border</h4><div>";
            uport_field('Border Color', 'catbordercolor', 'color', '', '', '', '0', $valarr, 'livecatli ' . $stepclass . ' ');
            uport_field('Border Width', 'catborderwidth', 'integer', '', '', '', '0', $valarr, 'livecatli ' . $stepclass . ' uport-spinner');
            uport_field('Border Radius', 'catborderradius', 'text', '', '', '', '0', $valarr, 'livecatli ' . $stepclass . ' uport-spinner');
        echo "</div></div>";

    echo "</div>";

    uport_field('', '', 'rowend', '', '', 'Set font name, size, color, border, spacing, background etc. of portfolio categories links. All numeric values are by default in pixels Eg: 5 will be treated as 5px. You can enter values in %,em too. <strong>Eg: 1em, 5%, 10px, 10</strong>. For Border radius, you can also enter 4 corner radius individually like eg: 50% 10% 40% 50% to make unique rounded corners and shapes.', '0', $valarr);






/*    uport_field('Portfolio Background', '', 'rowstart', '', '', '', '0', $valarr, 'csstabs cssportbg');
    uport_field('Color', 'portbgcolor', 'color', '', '', '', '0', $valarr, 'liveportbg');
    uport_field('Opacity', 'portbgopacity', 'integer', '', '', '', '0', $valarr, 'liveportbg uport-spinner-opacity');
    uport_field('', '', 'rowend', '', '', 'Full portfolio background style. Pick background color and its opacity of your item data. Eg: color as #eeeeee,white and opacity as 0.8 (from 0.0 to 1.0)', '0', $valarr);
*/


    uport_field('Above Layer', '', 'rowstart', '', '', '', '0', $valarr, 'csstabs cssabovetab');
    echo "<div class='uport-accordion'>";
    
        echo "<div class='group'><h4>Color</h4><div>";
            uport_field('Color', 'abovecolor', 'color', '', '', '', '0', $valarr, 'liveabove ' . $stepclass . ' ');
            uport_field('Background', 'abovebgcolor', 'color', '', '', '', '0', $valarr, 'liveabove ' . $stepclass . ' ');
        echo "</div></div>";

        echo "<div class='group'><h4>Font</h4><div>";
            uport_field('Font', 'abovefontname', 'select', 'Open Sans', $fontlist, '', '0', $valarr, 'liveabove ' . $stepclass . ' uport-combobox');
            uport_field('Backup Font', 'abovefontbackup', 'select', 'Open Sans', $fontbackuplist, '', '0', $valarr, 'liveabove ' . $stepclass . ' uport-combobox');
            uport_field('Font Weight & Style', 'abovefontweight', 'select', 'Open Sans', $fontweightlist, '', '0', $valarr, 'liveabove ' . $stepclass . ' uport-combobox');
            uport_field('Font Subset', 'abovefontsubset', 'select', 'Latin', $fontsubsetlist, '', '0', $valarr, 'liveabove ' . $stepclass . ' uport-combobox');
            uport_field('Font Size', 'abovefontsize', 'integer', '', '', '', '0', $valarr, 'liveabove ' . $stepclass . '  uport-spinner');
            uport_field('Align', 'abovealign', 'select', 'center', 'center:Center|left:Left|right:Right', '', '0', $valarr, 'liveabove ' . $stepclass . ' ');
            uport_field('Line Height', 'abovelineheight', 'integer', '', '', '', '0', $valarr, 'liveabove ' . $stepclass . '  uport-spinner');
        echo "</div></div>";

        echo "<div class='group'><h4>Spacing</h4><div>";

            uport_field('Position', 'abovepos', 'select', 'top', 'top:Top|bottom:Bottom', '', '0', $valarr, 'liveabove ' . $stepclass . ' ');

            uport_field('Padding:', '', 'label', '', '', '', '0', $valarr);
                uport_field('Top', 'abovepaddingtop', 'integer_label', '', '', '', '0', $valarr, 'liveabove ' . $stepclass . '  uport-spinner');
                uport_field('Right', 'abovepaddingright', 'integer_label', '', '', '', '0', $valarr, 'liveabove ' . $stepclass . '  uport-spinner');
                uport_field('Bottom', 'abovepaddingbottom', 'integer_label', '', '', '', '0', $valarr, 'liveabove ' . $stepclass . '  uport-spinner');
                uport_field('Left', 'abovepaddingleft', 'integer_label', '', '', '', '0', $valarr, 'liveabove ' . $stepclass . '  uport-spinner');
            uport_field('', '', 'labelend', '', '', '', '0', $valarr);
            uport_field('Margin:', '', 'label', '', '', '', '0', $valarr);
                uport_field('Top', 'abovemargintop', 'integer_label', '', '', '', '0', $valarr, 'liveabove ' . $stepclass . '  uport-spinner');
                uport_field('Right', 'abovemarginright', 'integer_label', '', '', '', '0', $valarr, 'liveabove ' . $stepclass . '  uport-spinner');
                uport_field('Bottom', 'abovemarginbottom', 'integer_label', '', '', '', '0', $valarr, 'liveabove ' . $stepclass . '  uport-spinner');
                uport_field('Left', 'abovemarginleft', 'integer_label', '', '', '', '0', $valarr, 'liveabove ' . $stepclass . '  uport-spinner');
            uport_field('', '', 'labelend', '', '', '', '0', $valarr);
        echo "</div></div>";

    echo "</div>";

    uport_field('', '', 'rowend', '', '', 'Set font name, size, color, alignment, position for the item details shown above image layer. It is shown only if any item detail in picked as above in layout section. All numeric values are by default in pixels Eg: 5 will be treated as 5px. You can enter values in %,em too. <strong>Eg: 1em, 5%, 10px, 10</strong>', '0', $valarr);


    uport_field('Price Style', '', 'rowstart', '', '', '', '0', $valarr, 'csstabs csspricetab');
    echo "<div class='uport-accordion'>";
    
        echo "<div class='group'><h4>Color</h4><div>";
            uport_field('Color', 'pricecolor', 'color', '', '', '', '0', $valarr, 'liveprice ' . $stepclass . ' ');
            uport_field('Background', 'pricebgcolor', 'color', '', '', '', '0', $valarr, 'liveprice ' . $stepclass . ' ');
        echo "</div></div>";

        echo "<div class='group'><h4>Font</h4><div>";
            uport_field('Font', 'pricefontname', 'select', 'Open Sans', $fontlist, '', '0', $valarr, 'liveprice ' . $stepclass . ' uport-combobox');
            uport_field('Backup Font', 'pricefontbackup', 'select', 'Open Sans', $fontbackuplist, '', '0', $valarr, 'liveprice ' . $stepclass . ' uport-combobox');
            uport_field('Font Weight & Style', 'pricefontweight', 'select', 'Open Sans', $fontweightlist, '', '0', $valarr, 'liveprice ' . $stepclass . ' uport-combobox');
            uport_field('Font Subset', 'pricefontsubset', 'select', 'Latin', $fontsubsetlist, '', '0', $valarr, 'liveprice ' . $stepclass . ' uport-combobox');
            uport_field('Font Size', 'pricefontsize', 'integer', '', '', '', '0', $valarr, 'liveprice ' . $stepclass . '  uport-spinner');
            uport_field('Align', 'pricealign', 'select', 'center', 'center:Center|left:Left|right:Right', '', '0', $valarr, 'liveprice ' . $stepclass . ' ');
            uport_field('Line Height', 'pricelineheight', 'integer', '', '', '', '0', $valarr, 'liveprice ' . $stepclass . '  uport-spinner');
        echo "</div></div>";

        echo "<div class='group'><h4>Spacing</h4><div>";
            uport_field('Padding:', '', 'label', '', '', '', '0', $valarr);
                uport_field('Top', 'pricepaddingtop', 'integer_label', '', '', '', '0', $valarr, 'liveprice ' . $stepclass . '  uport-spinner');
                uport_field('Right', 'pricepaddingright', 'integer_label', '', '', '', '0', $valarr, 'liveprice ' . $stepclass . '  uport-spinner');
                uport_field('Bottom', 'pricepaddingbottom', 'integer_label', '', '', '', '0', $valarr, 'liveprice ' . $stepclass . '  uport-spinner');
                uport_field('Left', 'pricepaddingleft', 'integer_label', '', '', '', '0', $valarr, 'liveprice ' . $stepclass . '  uport-spinner');
            uport_field('', '', 'labelend', '', '', '', '0', $valarr);
            uport_field('Margin:', '', 'label', '', '', '', '0', $valarr);
                uport_field('Top', 'pricemargintop', 'integer_label', '', '', '', '0', $valarr, 'liveprice ' . $stepclass . '  uport-spinner');
                uport_field('Right', 'pricemarginright', 'integer_label', '', '', '', '0', $valarr, 'liveprice ' . $stepclass . '  uport-spinner');
                uport_field('Bottom', 'pricemarginbottom', 'integer_label', '', '', '', '0', $valarr, 'liveprice ' . $stepclass . '  uport-spinner');
                uport_field('Left', 'pricemarginleft', 'integer_label', '', '', '', '0', $valarr, 'liveprice ' . $stepclass . '  uport-spinner');
            uport_field('', '', 'labelend', '', '', '', '0', $valarr);
        echo "</div></div>";

    echo "</div>";

    uport_field('', '', 'rowend', '', '', 'Set font name, size, color, alignment, bold, italic line height of price of item. All numeric values are by default in pixels Eg: 5 will be treated as 5px. You can enter values in %,em too. <strong>Eg: 1em, 5%, 10px, 10</strong>', '0', $valarr);


    echo "</table></div>";
    echo "<table border=0 class='formtable'><tr class='trspacer'><td colspan=5></td></tr>";

    echo uport_ajax_save_row('3');

    echo "<input type='hidden' name='uport_titlevalues' id='uport_titlevalues' value='" . uport_fields('step3_title') . "'>
<input type='hidden' name='uport_descvalues' id='uport_descvalues' value='" . uport_fields('step3_desc') . "'>
<input type='hidden' name='uport_slugvalues' id='uport_slugvalues' value='" . uport_fields('step3_slug') . "'>
<input type='hidden' name='uport_maskbgvalues' id='uport_maskbgvalues' value='" . uport_fields('step3_maskbg') . "'>
<input type='hidden' name='uport_outbgvalues' id='uport_outbgvalues' value='" . uport_fields('step3_outbg') . "'>
<input type='hidden' name='uport_portbgvalues' id='uport_portbgvalues' value='" . uport_fields('step3_portbg') . "'>
<input type='hidden' name='uport_bordervalues' id='uport_bordervalues' value='" . uport_fields('step3_border') . "'>
<input type='hidden' name='uport_shadowvalues' id='uport_shadowvalues' value='" . uport_fields('step3_shadow') . "'>
<input type='hidden' name='uport_catulvalues' id='uport_catulvalues' value='" . uport_fields('step3_catul') . "'>
<input type='hidden' name='uport_catlivalues' id='uport_catlivalues' value='" . uport_fields('step3_catli') . "'>
<input type='hidden' name='uport_catlihovervalues' id='uport_catlihovervalues' value='" . uport_fields('step3_catlihover') . "'>
<input type='hidden' name='uport_butvalues' id='uport_butvalues' value='" . uport_fields('step3_but') . "'>
<input type='hidden' name='uport_buthovervalues' id='uport_buthovervalues' value='" . uport_fields('step3_buthover') . "'>
<input type='hidden' name='uport_pricevalues' id='uport_pricevalues' value='" . uport_fields('step3_price') . "'>
<input type='hidden' name='uport_abovevalues' id='uport_abovevalues' value='" . uport_fields('step3_above') . "'>
<input type='hidden' name='uport_settingids_3' id='uport_settingids_3' value='" . uport_fields('step3') . "'>";

    echo "</table></form>";
}

function uport_save_step3() {
    uport_save_common('3');
}

/* * *************************************************************** */

function uport_panel_step4($valarr, $step_head = "") {

    $stepclass = " uport_4_field ";

    echo "<h3>" . $step_head . "<div class='uport_save_msg_step4 uport_save_msg'></div></h3>
<form action='javascript:void();' class='formwrap'><table border=0 class='formtable'><tr class='trspacer'><td colspan=5></td></tr>";

    $detailids = uport_effect_list('str');
    uport_field('Overlay Effect', 'overlayeffect', 'effectlist', 'effect1', $detailids, 'Pick your item overlay effect (Transition effect when mouse hovers on item).<br>Note: All the item details will be displayed based on effect selected.', '1', $valarr, $stepclass);

    $detailids = "smooth: Smooth|snap: Snap|windup: Wind Up|windback: Wind Back";
    uport_field('Filter Easing Type (Grid Layout)', 'mixeasing', 'select', 'smooth', $detailids, 'Pick your easing settings for filtering.', '1', $valarr, $stepclass,""," is_dependent dependent_on_uporttype uporttype_grid ");


    $detailids = "0:Select (multi)|fade: Fade|scale: Scale|rotateZ: Rotate On Z-axis|rotateX: Rotate On X-axis|rotateY: Rotate On Y-axis|blur: Blur|grayscale: Grayscale|";
    uport_field('Filtering Effects (Grid Layout)', 'mixeffects', 'select_multi', 'fade|scale', $detailids, 'Check the effects for filtering. You can pick multiple effects and unique presentations.', '1', $valarr, $stepclass." uport-combobox-multi ",""," is_dependent dependent_on_uporttype uporttype_grid ");


    $detailids = "linear|ease|easeIn|easeOut|easeInOut|easeInQuad|easeInCubic|easeInQuart|easeInQuint|easeInSine|easeInExpo|easeInCirc|easeInBack|easeOutQuad|easeOutCubic|easeOutQuart|easeOutQuint|easeOutSine|easeOutExpo|easeOutCirc|easeOutBack|easeInOutQuad|easeInOutCubic|easeInOutQuart|easeInOutQuint|easeInOutSine|easeInOutExpo|easeInOutCirc|easeInOutBack";
    uport_field('Filtering Effects (Masonary Layout)', 'isoeffects', 'select', 'linear', $detailids, 'Check the effects for filtering masonary portfolio only.', '1', $valarr, $stepclass,""," is_dependent dependent_on_uporttype uporttype_masonary ");

    // mix and iso speed - both filtering speed
    uport_field('Filtering Transition Speed', 'mixspeed', 'integer', '600', '', 'The speed of the filter or sort animation in milliseconds, including any easing. Eg: 600', '1', $valarr, $stepclass,""," is_dependent dependent_on_uporttype uporttype_grid uporttype_masonary ");


    // slider / single
    uport_field('Slide Speed', 'owlslidespeed', 'integer', '800', '', 'The transition speed of slide in milliseconds Eg: 800', '1', $valarr, $stepclass,""," is_dependent dependent_on_uporttype uporttype_slider uporttype_single ");
    uport_field('Pagination Speed', 'owlpagespeed', 'integer', '800', '', 'The transition speed of slide pagination in milliseconds Eg: 800', '1', $valarr, $stepclass,""," is_dependent dependent_on_uporttype uporttype_slider uporttype_single ");
    uport_field('Rewind Speed', 'owlrewindspeed', 'integer', '1000', '', 'The transition speed of slide rewind back to first slide again in milliseconds Eg: 1000', '1', $valarr, $stepclass,""," is_dependent dependent_on_uporttype uporttype_slider uporttype_single ");

    // slider / single
    $detailids = "true: On|false: Off";
    uport_field('Autoplay', 'owlautoplay', 'select', 'true', $detailids, 'Choose to autoplay slides or not.', '1', $valarr, $stepclass,""," is_dependent dependent_on_uporttype uporttype_slider uporttype_single ");

    // slider / single
    $detailids = "true: Yes|false: No";
    uport_field('Navigation', 'owlnavigation', 'select', 'true', $detailids, 'Choose to show previous and next navigation buttons.', '1', $valarr, $stepclass,""," is_dependent dependent_on_uporttype uporttype_slider uporttype_single ");
    uport_field('Pagination', 'owlpagination', 'select', 'true', $detailids, 'Choose to show pagination buttons based on number of slides.', '1', $valarr, $stepclass,""," is_dependent dependent_on_uporttype uporttype_slider uporttype_single ");
    uport_field('Play/Stop button', 'owlplaystop', 'select', 'true', $detailids, 'Choose to show play and stop slides button.', '1', $valarr, $stepclass,""," is_dependent dependent_on_uporttype uporttype_slider uporttype_single ");

    // slider / single
    $detailids = "false: Item|true: Slide";
    uport_field('Scroll Item/Slide', 'owlscrollPerPage', 'select', 'false', $detailids, 'Choose to scroll single item or full slide once a time.', '1', $valarr, $stepclass,""," is_dependent dependent_on_uporttype uporttype_slider ");


    echo uport_ajax_save_row('4');

    echo "<input type='hidden' name='uport_settingids_4' id='uport_settingids_4' value='" . uport_fields('step4') . "'></table></form>";
}

function uport_save_step4() {
    uport_save_common('4');
}




add_action('wp_ajax_uport_sort_portfolio_items', 'uport_sort_portfolio_items_list');

function uport_sort_portfolio_items_list(){

    if (!isset($_POST['uport_nonce']) || !wp_verify_nonce($_POST['uport_nonce'], 'uport-nonce')) {
        die('Permissions check failed. Please login or refresh (if already logged in) the page, then try Again.');
    }

    $catids = $_POST['catids'];
    $woocatids = $_POST['woocatids'];
    $pid = $_POST['pid'];
    $id = $_POST['id'];

    //print_r($_POST);

    $catarr = array_unique(array_filter(explode("|", $catids)));
    //print_r($catarr);




        /* --------------------------
          Load Woocommerce Item
          -------------------------- */
            $woo_status = false;
            if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                $woo_status = true;
            }

            $woocatarr = array();
            if($woo_status){
                $woocatarr = array_unique(array_filter(explode("|", $woocatids)));
                //print_r($woocatarr);
            }

            $wooitem = array();

            if($woo_status){
                $woolist = uport_wooitems($woocatarr,$_POST['sortorder']);
            }
            //echo "<pre>"; print_r($woolist); echo "</pre>";


        /* --------------------------
          Query - load categories
          -------------------------- */
            $query = "";
            foreach ($catarr as $c) {
                $query .= "item_category LIKE '%|" . $c . "|%' OR ";
            }
            $query = substr($query, 0, -3);
            //echo $query;
            global $wpdb;
            if (trim($query) != "") {
                $list = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'uport_items WHERE ' . $query . '');
            }


            //echo "<pre>"; print_r($list); echo "</pre>";
        // merge all items in one array of objects

        $allitem = array();

        if($woo_status){
            $allitem = array_merge($list,$woolist);
        } else {
            $allitem = $list;
        }

        $allitem = sort_object_by_order($allitem,$_POST['sortorder']);
        //echo "<pre>"; print_r($allitem); echo "</pre>";

    echo '<ul id="sortable">';

        foreach($allitem as $item){
            $itemthumb = uport_upload_url($item->item_thumbnail);

                    // if empty return url then use original
                    $thumbimage = aq_uport_resize($itemthumb, "60","60",true);
                    if (trim($thumbimage) == "" || trim($thumbimage) == false) {
                        $thumbimage = $ori_image;
                    }

                    echo '<li class="ui-state-default" data-item="'.$item->item_title.'" id="_'.$item->item_id.'">
                            <div class="list-label"><img src="'.$thumbimage.'"><span>'.$item->item_title.'</span></div>
                        </li>';
        }

    echo "</ul>";
    
    die();
}


function uport_ajax_save_row($id) {

    return "<tr><td colspan=2 class='savedatabut1'>
    <input type='button' name='uport_submitstep" . $id . "' id='uport_submitstep" . $id . "' value='Save Section' class='savebut'>
    <input type='button' class='uport_submitstepall' value='Save All Section' class='savebut savebutall'>
    <div id='uport_save_step" . $id . "_result' style='display:none;' class='uport_savetxt'></div>
    <div id='uport_save_stepall_result' style='display:none;' class='uport_savetxt uport_savetxtall'></div>
    </td></tr>";
}

function uport_save_common($stepid) {
    if (!isset($_POST['uport_nonce']) || !wp_verify_nonce($_POST['uport_nonce'], 'uport-nonce')) {
        die('Permissions check failed. Please login or refresh (if already logged in) the page, then try Again.');
    }

    global $wpdb;
    $table_name1 = $wpdb->prefix . "uport";
    $id = $_POST['id'];
    $timezone = "";
    if (date_default_timezone_get()) {
        $timezone = date_default_timezone_get();
    }
    $datetime = date("Y-m-d H:i:s") . " " . $timezone;

    //print_r($_POST);


    if ($stepid == "all") {

        $values1 = $_POST['values1'];
        $values2 = $_POST['values2'];
        $values3 = $_POST['values3'];
        $values4 = $_POST['values4'];

        if ($id == "") {
            $wpdb->query($wpdb->prepare(" INSERT INTO " . $table_name1 . " SET `step1val` = %s, `step2val` = %s, `step3val` = %s, `step4val` = %s, `updatedon` = %s , `active` = 1 ", $values1, $values2, $values3, $values4, $datetime));
            $newid = $wpdb->insert_id;
            echo "<script type='text/javascript'> document.getElementById('uport_id').value = '" . $newid . "'; jQuery(function($) { newLivePreview(); }); console.log('All section saved and new id created');</script>";
        } else {
            $wpdb->query($wpdb->prepare(" UPDATE " . $table_name1 . " SET `step1val` = %s , `step2val` = %s , `step3val` = %s , `step4val` = %s , `updatedon` = %s  WHERE `id` = %d ", $values1, $values2, $values3, $values4, $datetime, $id));
            $newid = $id;
        }

        echo "Saved All";
    } else {

        $values = $_POST['values'];

        if ($id == "") {
            $wpdb->query($wpdb->prepare(" INSERT INTO " . $table_name1 . " SET `step" . $stepid . "val` = %s, `updatedon` = %s , `active` = 1 ", $values, $datetime));
            $newid = $wpdb->insert_id;
            echo "<script type='text/javascript'> document.getElementById('uport_id').value = '" . $newid . "'; jQuery(function($) { newLivePreview(); }); console.log('new id created');</script>";
        } else {
            $wpdb->query($wpdb->prepare(" UPDATE " . $table_name1 . " SET `step" . $stepid . "val` = %s , `updatedon` = %s  WHERE `id` = %d ", $values, $datetime, $id));
            $newid = $id;
        }

        echo "Saved";
    }

    die();
}
?>